function squareGen(size, lineSize, color)
    return rectGen(size, size, lineSize, color);
end;

function rectGen(width, height, lineSize, bgColor)
    return Def.ActorFrame{
    
        --Background transparency
        Def.Quad{
            InitCommand=cmd(setsize,width, height;diffuse,bgColor);
            
        };
        --Bottom line
        Def.Quad{
            InitCommand=cmd(setsize,width + lineSize, lineSize;addy,height/2;--[[horizalign,0;vertalign,2]]);
            
        };
        --Top line
        Def.Quad{
            InitCommand=cmd(setsize,width + lineSize, lineSize;addy,-height/2;--[[horizalign,2;vertalign,0]]); --2 = right aligned
            
        };
        --Left line
        Def.Quad{
            InitCommand=cmd(setsize,lineSize, height + lineSize;addx,-width/2;--[[vertalign,0;horizalign,2]]); --2 = right aligned
            
        };
        --Right line
        Def.Quad{
            InitCommand=cmd(setsize,lineSize, height + lineSize;addx,width/2;--[[vertalign,2;horizalign,0]]); --2 = bottom aligned
            
        };
        

    };
end;

--Draws a 50px triangle
function triangleGen(x, y, clr)
    --[[
    How to use vertices:
    Define points in the verts table as seen below.
    Usage: {{x, y, z}, Color}
    Eample: {{0, 20, 0}, Color.Red}
    
    For a square, you need four, for a triangle, three.
    If you put more than the required amount it will draw more shapes, ex: 6 for two triangles, 8 for two squares.
    If you put an uneven amount it will ignore the extras.
    ]]
    local verts = {
        --Note that it's reversed from your normal graph. 40 is 40 pixels down, not up.
        {{0, 0, 0}, clr},
        {{50, 0, 0}, clr},
		{{0, 50, 0}, clr}
        
    };
    return Def.ActorMultiVertex{
        InitCommand=function(self)
            self:xy(x, y);
            self:SetDrawState{Mode="DrawMode_Triangles"}
            self:SetVertices(verts)
        end;
        
    };
end;

function parallelogramGen(width,height,clr)
	return Def.ActorFrame{
		Def.Quad{
			InitCommand=cmd(setsize,width-height,height;diffuse,clr);
		};
		Def.ActorMultiVertex{
			InitCommand=function(self)
				self:xy((width-height)/2,-height/2);
				self:SetDrawState{Mode="DrawMode_Triangles"}
				self:SetVertices({
					{{0, 0, 0}, clr},
					{{height, 0, 0}, clr},
					{{0, height, 0}, clr}
			
				});
			end;
		};
		Def.ActorMultiVertex{
			InitCommand=function(self)
				self:xy(-(width+height)/2,-height/2);
				self:SetDrawState{Mode="DrawMode_Triangles"}
				self:SetVertices({
					{{height, height, 0}, clr},
					{{0, height, 0}, clr},
					{{height, 0, 0}, clr}
				});
			end;
		};

	};
end
